import React from 'react';
import cn from 'classnames';
import Button from '@material-ui/core/Button';
import useStyles from './styles';

type Props = {
    styles: object,
    variant: string,
    btnSize: 'small' | 'big'
};

function StyledButton(props: Props) {
    const classes = useStyles();
    const { styles, variant, btnSize, ...rest } = props;
    return (
        <Button
            className={cn(
                classes.styledButton,
                { [classes.outlined]: variant === 'outlined' },
                { [classes.smallSize]: btnSize === 'small' },
                { [classes.bigSize]: btnSize === 'big' },
                styles
            )}
            {...rest}
        />
    );
}

export default StyledButton;
